@php
$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Ana Menüler')
@section('vendor-style')
<link rel="stylesheet" href="{{asset('assets/vendor/libs/animate-css/animate.css')}}" />
<link rel="stylesheet" href="{{asset('assets/vendor/libs/sweetalert2/sweetalert2.css')}}" />
@endsection

@section('vendor-script')
<script src="{{asset('assets/vendor/libs/sweetalert2/sweetalert2.js')}}"></script>
<script src="{{asset('assets/vendor/libs/cleavejs/cleave.js')}}"></script>
@if (session('success'))
<script>
    Swal.fire({
        icon: 'success',
        title: 'Başarılı!',
        text: '{{ session('success') }}',
        showConfirmButton: false,
        timer: 1500
    });
</script>

@elseif (session('error'))
<script>
    Swal.fire({
        icon: 'error',
        title: 'Oops...',
        text: '{{ session('error') }}',
        showConfirmButton: false,
        timer: 1500
    });
</script>
@endif

@endsection

@section('content')

<h4>Ana Menüler</h4>

<div class="d-grid gap-2 d-md-flex justify-content-md-end">
    <form action="{{ route('ana_menu.index') }}" method="GET" class="d-inline">
        <div class="input-group mb-3">
            <input type="text" class="form-control" name="arama" placeholder="Arama" value="{{ $search_data['arama'] ?? '' }}">
            <button class="btn btn-outline-secondary" type="submit" id="button-addon2">Ara</button>
        </div>
    </form>
    <a href="{{ route('ana_menu.create') }}" class="btn btn-success mb-3">+ Yeni Ana Menü Ekle</a>
</div>


<div class="row">
    <div class="col-lg-12 col-sm-12">
        <div class="card">
          <h5 class="card-header"><span class="text-success">Toplam Menü: {{$ana_menu_count}} Adet</span></h5>
          <div class="table-responsive text-nowrap">
            <table class="table">
              <thead>
                <tr>
                    <th>İsim</th>
                    <th>Sıra</th>
                    <th>İşlemler</th>
                </tr>
              </thead>
              <tbody class="table-border-bottom-0">
                @foreach ($ana_menus as $ana_menu)
                <tr>
                    <td class="w-50">{{ $ana_menu->name }}</td>
                    <td>{{ $ana_menu->sira }}</td>
                    <td>
                        <a href="{{ route('ana_menu.show', $ana_menu->id) }}" class="btn btn-sm btn-outline-primary">Görüntüle</a>
                        <a href="{{ route('ana_menu.edit', $ana_menu->id) }}" class="btn btn-sm btn-outline-warning">Düzenle</a>
                        <form action="{{ route('ana_menu.destroy', $ana_menu->id) }}" method="POST" class="d-inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-outline-danger">Sil</button>
                        </form>
                    </td>
                </tr>
                @endforeach
              </tbody>
            </table>
            <div class="d-flex justify-content-center mt-3">
                {!! $ana_menus->links() !!}
            </div>
          </div>
        </div>
    </div>
</div>


@endsection
