<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\AnaMenu;
use App\Models\AltMenu;
use App\Models\Yemek;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File as FacadesFile;

class AltMenuController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $alt_menus = AltMenu::join('ana_menus', 'alt_menus.ana_menu_id', '=', 'ana_menus.id')
        ->select('alt_menus.*', 'ana_menus.name as ana_menu_name')
        ->orderBy('alt_menus.sira');

        $search_data = array();
        if ($request->has('arama')){
            $search_data['arama'] = $request->input('arama');
            $alt_menus = $alt_menus->where('alt_menus.name', 'like', '%'.$search_data['arama'].'%');
        }
        if ($request->has('ana_menu_id')){
            $search_data['ana_menu_id'] = $request->input('ana_menu_id');
            $alt_menus = $alt_menus->where('alt_menus.ana_menu_id', $search_data['ana_menu_id']);
        }
        $alt_menu_count = AltMenu::where('id', '>', 0)->count();
        $ana_menus = AnaMenu::select('id','name')->orderBy('sira')->get();
        $alt_menus = $alt_menus->where('alt_menus.id', '>', 0);
        $alt_menus = $alt_menus->paginate(10);
        return view('admin.alt_menu.index', compact('alt_menus', 'alt_menu_count', 'ana_menus', 'search_data'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $ana_menus = AnaMenu::select('id','name')->orderBy('sira')->get();
        return view('admin.alt_menu.create', compact('ana_menus'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate(
            [
                'name' => 'required',
                'image' => 'required|image|mimes:jpeg,png,jpg|max:2048',
                'sira' => 'required',
                'ana_menu_id' => 'required',
            ]
        );
        $alt_menu = new AltMenu();
        $alt_menu->name = $request->name;
        $alt_menu->sira = $request->sira;
        $alt_menu->ana_menu_id = $request->ana_menu_id;
        $file = $request->file('image');
        if ($request->hasFile('image')) {
            $profile_photo_path = bin2hex(random_bytes(32));
            $file_name = $profile_photo_path . '.' . $file->getClientOriginalExtension();
            Storage::disk('public')->put($file_name, FacadesFile::get($file));
        }else{
            return redirect()->back()->with('error', 'Resim yüklenemedi.');
        }
        $alt_menu->image = $file_name;
        $alt_menu->save();
        return redirect()->route('alt_menu.index')->with('success', 'Alt Menü Başarıyla Eklendi.');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $data = AltMenu::join('ana_menus', 'alt_menus.ana_menu_id', '=', 'ana_menus.id')
        ->select('alt_menus.*', 'ana_menus.name as ana_menu_name')
        ->where('alt_menus.id', $id)
        ->first();
        if (!$data) {
            return redirect()->route('alt_menu.index')->with('error', 'Alt Menü Bulunamadı.');
        }
        return view('admin.alt_menu.show', compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $data = AltMenu::join('ana_menus', 'alt_menus.ana_menu_id', '=', 'ana_menus.id')
        ->select('alt_menus.*', 'ana_menus.name as ana_menu_name')
        ->where('alt_menus.id', $id)
        ->first();
        if (!$data) {
            return redirect()->route('alt_menu.index')->with('error', 'Alt Menü Bulunamadı.');
        }
        $ana_menus = AnaMenu::select('id','name')->orderBy('sira')->get();
        return view('admin.alt_menu.edit', compact('data', 'ana_menus'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $request->validate(
            [
                'name' => 'required',
                'sira' => 'required',
                'ana_menu_id' => 'required',
            ]
        );
        $alt_menu = AltMenu::find($id);
        $alt_menu->name = $request->name;
        $alt_menu->sira = $request->sira;
        $alt_menu->ana_menu_id = $request->ana_menu_id;
        if ($request->hasFile('image')) {
            if (Storage::disk('public')->exists($alt_menu->image)) {
                Storage::disk('public')->delete($alt_menu->image);
            }
            $file = $request->file('image');
            $profile_photo_path = bin2hex(random_bytes(32));
            $file_name = $profile_photo_path . '.' . $file->getClientOriginalExtension();
            Storage::disk('public')->put($file_name, FacadesFile::get($file));
            $alt_menu->image = $file_name;
        }
        $alt_menu->save();
        return redirect()->route('alt_menu.index')->with('success', 'Alt Menü Başarıyla Güncellendi.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $alt_menu = AltMenu::find($id);
        if (!$alt_menu) {
            return redirect()->route('alt_menu.index')->with('error', 'Alt Menü Bulunamadı.');
        }
        if (Storage::disk('public')->exists($alt_menu->image)) {
            Storage::disk('public')->delete($alt_menu->image);
        }
        $alt_menu->delete();
        $yemekler = Yemek::where('alt_menu_id', $id)->get();
        foreach ($yemekler as $yemek) {
            if (Storage::disk('public')->exists($yemek->image)) {
                Storage::disk('public')->delete($yemek->image);
            }
            $yemek->delete();
        }
        return redirect()->route('alt_menu.index')->with('success', 'Alt Menü Başarıyla Silindi.');
    }
}
